// MSio.cpp : implementation file
//

#include "stdafx.h"
#include "MtoMSIO\MtoMSioApi.h"
#include "MSio.h"
//#include "MemSock.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// MSio


CMSio::CMSio(void* pParent, LPMtoMSioConfig pConfig/*=NULL*/)
{
	m_pParent = pParent ;
	ASSERT( m_pParent ) ;
	if( pConfig )
	{
		m_hSio = ::SIO_CreateMtoMSio(pConfig) ;
		ASSERT( m_hSio ) ;
	}
	else
	{
		m_hSio = NULL ;
	}
}

CMSio::~CMSio()
{
	::SIO_FreeMtoMSio(m_hSio);
}

int CMSio::OpenMtoMSio(LPMtoMSioConfig pConfig/*=NULL*/)
{
	if( m_hSio && pConfig )
	{
		::SIO_FreeMtoMSio(m_hSio);
		m_hSio = ::SIO_CreateMtoMSio(pConfig) ;
	}
	ASSERT( m_hSio ) ;
	return( ::SIO_OpenMtoM(m_hSio) );
}


int CMSio::CloseMtoM()
{
	return( ::SIO_CloseMtoM(m_hSio)) ;
}

int CMSio::MtoMESC_W(WORD wAddress,INT iDataCount,WORD* pwData)	
{
	return( ::SIO_MtoMESC_W(m_hSio,wAddress,iDataCount,pwData)) ;
}

int CMSio::MtoMESC_R(WORD wAddress,INT iDataCount,WORD* pwoData)	
{
	return( ::SIO_MtoMESC_R(m_hSio,wAddress,iDataCount,pwoData)) ;
}

int CMSio::MtoMESC_T(GPCOLOR cDisplayColor,GPCOLOR cBackColor, INT iX1,INT iY1,GPFONTSIZE cFontSize,CHAR* szString)	
{
	return( ::SIO_MtoMESC_T(m_hSio,cDisplayColor,cBackColor,iX1,iY1,cFontSize,szString)) ;
}

int CMSio::MtoMESC_L(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iX2,INT iY2)
{
	return( ::SIO_MtoMESC_L(m_hSio,cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iX2,iY2)) ;
}

int CMSio::MtoMESC_B(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iX2,INT iY2)
{
	return( ::SIO_MtoMESC_B(m_hSio,cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iX2,iY2)) ;
}

int CMSio::MtoMESC_S(GPCOLOR cDisplayColor,GPCOLOR cBackColor,INT iX1,INT iY1,INT iX2,INT iY2,GPTILE cTile)
{
	return( ::SIO_MtoMESC_S(m_hSio,cDisplayColor,cBackColor,iX1,iY1,iX2,iY2,cTile)) ;
}

int CMSio::MtoMESC_C(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius)
{
	return( ::SIO_MtoMESC_C(m_hSio,cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius)) ;
}

int CMSio::MtoMESC_A(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle)
{
	return( ::SIO_MtoMESC_A(m_hSio,cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius,iStartAngle,iEndAngle)) ;
}

int CMSio::MtoMESC_G(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle)
{
	return( ::SIO_MtoMESC_G(m_hSio,cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius,iStartAngle,iEndAngle)) ;
}
int CMSio::MtoMESC_I(BOOL* pbHave,DWORD *pdwCode)
{
	return( ::SIO_MtoMESC_I(m_hSio,pbHave,pdwCode)) ;
}

int CMSio::MtoMESC_t(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPFONT cFont,INT iTurn,INT iDirection,INT iHalfcentering,INT iEmphasis,GPCOLOR cSculpture,INT iX1,INT iY1,GPFONTSIZE cFontSize,CHAR* szString)
{
	return( ::SIO_MtoMESC_t(m_hSio,cDisplayColor,cBackColor,cFont,iTurn,iDirection,iHalfcentering,iEmphasis,cSculpture,iX1,iY1,cFontSize,szString)) ;
}

int CMSio::MtoMESC_l(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iArrowPattern,INT iArrowDirection,INT iX1,INT iY1,INT iX2,INT iY2)
{
	return( ::SIO_MtoMESC_l(m_hSio,cDisplayColor,cBackColor,cLineStyle,iArrowPattern,iArrowDirection,iX1,iY1,iX2,iY2)) ;
}
int CMSio::MtoMESC_b(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iCornerDirection,INT iCornerRadius,INT iX1,INT iY1,INT iX2,INT iY2)
{
	return( ::SIO_MtoMESC_b(m_hSio,cDisplayColor,cBackColor,cLineStyle,iCornerDirection,iCornerRadius,iX1,iY1,iX2,iY2)) ;
}
int CMSio::MtoMESC_s(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iCornerDirection,INT iCornerRadius,INT iX1,INT iY1,INT iX2,INT iY2)
{
	return( ::SIO_MtoMESC_s(m_hSio,cDisplayColor,cBackColor,cTile,iCornerDirection,iCornerRadius,iX1,iY1,iX2,iY2)) ;
}

int CMSio::MtoMESC_c(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iX1,INT iY1,INT iRadius)
{
	return( ::SIO_MtoMESC_c(m_hSio,cDisplayColor,cBackColor,cTile,iX1,iY1,iRadius)) ;
}

int CMSio::MtoMESC_g(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle)
{
	return( ::SIO_MtoMESC_g(m_hSio,cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius,iStartAngle,iEndAngle)) ;
}

int CMSio::MtoMESC_SetContrast(DWORD dwContrast,DWORD dwLight)
{
	return( ::SIO_MtoMESC_SetContrast(m_hSio,dwContrast,dwLight)) ;
}

int CMSio::MtoMESC_GetContrast(DWORD *dwContrast,DWORD *dwLight)
{
	return( ::SIO_MtoMESC_GetContrast(m_hSio,dwContrast,dwLight));
}

int CMSio::MtoMESC_Y(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iPosCount,INT* piX,INT* piY)
{
	return( ::SIO_MtoMESC_Y(m_hSio,cDisplayColor,cBackColor,cLineStyle,iPosCount,piX,piY));
}
int CMSio::MtoMESC_y(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iPosCount,INT* piX,INT* piY)
{
	return( ::SIO_MtoMESC_y(m_hSio,cDisplayColor,cBackColor,cTile,iPosCount,piX,piY));
}

int CMSio::MtoMESC_M(GPCOLOR cDisplayColor,GPCOLOR cBackColor,BYTE bFontType,WORD wLanguage,BYTE bPriority,WCHAR* szString)
{
	return( ::SIO_MtoMESC_M(m_hSio,cDisplayColor,cBackColor,bFontType,wLanguage,bPriority,szString));
}

int CMSio::MtoMESC_m(void)
{
	return( ::SIO_MtoMESC_m(m_hSio));
}

DWORD CMSio::MtoMGetLastError(void)
{
	return( ::SIO_MtoMGetLastError(m_hSio)) ;
}
